function utl_isPromise(obj) {
    return !!obj && ("object" == typeof obj || "function" == typeof obj) && "function" == typeof obj.then
}

function utl_isNumber(num) {
    return "number" == typeof num ? num - num == 0 : "string" == typeof num && "" !== num.trim() && (Number.isFinite ? Number.isFinite(+num) : isFinite(+num))
}

function utl_isOdd(value) {
    const n = Math.abs(value);
    if (!isNumber(n)) throw new TypeError("expected a number");
    if (!Number.isInteger(n)) throw new Error("expected an integer");
    if (!Number.isSafeInteger(n)) throw new Error("value exceeds maximum safe integer");
    return n % 2 == 1
}

function utl_isObj(x) {
    var type = typeof x;
    return null !== x && ("object" === type || "function" === type)
}
var toString = Object.prototype.toString;

function utl_isPlainObj(x) {
    var prototype;
    return "[object Object]" === toString.call(x) && (null === (prototype = Object.getPrototypeOf(x)) || prototype === Object.getPrototypeOf({}))
}

function getRemCookies() {
    var userName = getCookie("userName"),
        pwd = "",
        onRemCookieSt = getCookie("onRemCookie"),
        pwdCookieSt = getCookie("passWord");
    pwdCookieSt.length > 0 && (pwd = "******"), "true" == onRemCookieSt ? (document.getElementById("inputRemember").checked = !0, document.getElementById("username").value = unescape(userName), document.getElementById("password").value = pwdCookieSt) : (document.getElementById("inputRemember").checked = !1, document.getElementById("username").value = "", document.getElementById("password").value = "", delCookie("userName"), delCookie("passWord"), PwdKeyFirst[0] = !1)
}

function setUserNameCursor() {
    document.getElementById("username").focus()
}

function StripTailSpace(desStr) {
    return desStr.replace(/\s+$/g, "")
}

function getURLParameter(name, url) {
    url || (url = window.location.href), name = name.replace(/[\[\]]/g, "\\$&");
    var regex, results = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)").exec(url);
    return results ? results[2] ? decodeURIComponent(results[2].replace(/\+/g, " ")) : "" : null
}

function setLangConfig(param) {
    var pos;
    if ((pos = param.indexOf("?")) > 0) tempstr = getURLParameter("lang", window.location.href), "CHINESE_S" == tempstr ? (CONTROL_WEB_2_FUNCTION.LANG = "CHINESE_S", IPNC.WebLanguageNum = 1) : "CHINESE_T" == tempstr ? (CONTROL_WEB_2_FUNCTION.LANG = "CHINESE_T", IPNC.WebLanguageNum = 2) : (CONTROL_WEB_2_FUNCTION.LANG = "ENGLISH", IPNC.WebLanguageNum = 0);
    else {
        var pos = param.indexOf("/html/"),
            parastr = param.substring(pos + 6);
        CONTROL_WEB_2_FUNCTION.LANG = "ENGLISH", IPNC.WebLanguageNum = 0
    }
}

function getLangConfig() {
    return CONTROL_WEB_2_FUNCTION.LANG
}

function getLocationRefWithLang(locationurl) {
    return "CHINESE_S" == CONTROL_WEB_2_FUNCTION.LANG ? locationurl += "?lang=CHINESE_S&_=" + GetRandNum() : "CHINESE_T" == CONTROL_WEB_2_FUNCTION.LANG ? locationurl += "?lang=CHINESE_T&_=" + GetRandNum() : locationurl += "?lang=ENGLISH&_=" + GetRandNum(), locationurl
}

function getQueryString(queryString) {
    for (var result = {}, queryString = location.search.slice(1), re = /([^&=]+)=([^&]*)/g, m; m = re.exec(queryString);) result[decodeURIComponent(m[1])] = decodeURIComponent(m[2]);
    return result
}

function submit3(cookieTime) {
    "userLogin" == ThisPage && (location.href = "ptzcontrol.html")
}

function EncryptCookie(UserName, PassWord, cookieTime, submitFlag) {
    showMessageModal(msgTitleLang, changePasswordLang, curry(submit3, cookieTime))
}
var RefreshTime = 3e4,
    RefreshTime2 = 2e3;

function restartTimerManager(refreshHndlr1, refreshHndlr2) {
    CONTROL_WEB_2_FUNCTION.ONOFF && (timerManager.clear(), timerManager.createSeqIntervalTimer(refreshHndlr1, RefreshTime), timerManager.createSeqIntervalTimer(refreshHndlr2, RefreshTime2))
}

function updatePageSettingCombobox(nowSettings, newSettings, optionId, option) {
    document.getElementById(optionId).selectedIndex = newSettings[option], nowSettings[option] = newSettings[option]
}

function updatePageSettingText(nowSettings, newSettings, optionId, option) {
    document.getElementById(optionId).value = newSettings[option], nowSettings[option] = newSettings[option]
}

function updatePageSettingCheckbox(nowSettings, newSettings, optionId, option) {
    document.getElementById(optionId).checked = 1 === newSettings[option], nowSettings[option] = newSettings[option]
}
var SendCmd = !0;

function setCmdAction(textId, para, value, refreshHndlr) {
    var cmdVal = para + "=";
    SendCmd && (cmdVal = cmdVal.concat(value), SendCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: cmdVal,
        success: function (data) {
            $(textId).val(value), SendCmd = !0
        },
        error: function (data) {
            SendCmd = !0
        }
    }))
}
var SendFocusCmd = !0,
    SendNearStopCmd = !0,
    SendFarStopCmd = !0;

function setFocusAction(textId, value, refreshHndlr) {
    var cmdVal = "focuspositon=";
    SendFocusCmd && (cmdVal = cmdVal.concat(value), restartTimerManager(refreshHndlr), SendFocusCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: cmdVal,
        success: function (data) {
            $(textId).val(value), SendFocusCmd = !0
        },
        error: function (data) {
            SendFocusCmd = !0
        }
    }))
}

function nearStartAction(refreshHndlr) {
    SendFocusCmd && (restartTimerManager(refreshHndlr), SendFocusCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "focusmanualnear=1",
        success: function (data) {
            SendFocusCmd = !0
        },
        error: function (data) {
            SendFocusCmd = !0
        }
    }))
}

function nearStopAction(refreshHndlr) {
    SendNearStopCmd && (restartTimerManager(refreshHndlr), SendNearStopCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "focusmanualnear=0",
        success: function (data) {
            SendNearStopCmd = !0
        },
        error: function (data) {
            SendNearStopCmd = !0
        }
    }))
}

function farStartAction(refreshHndlr) {
    SendFocusCmd && (restartTimerManager(refreshHndlr), SendFocusCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "focusmanualnfar=1",
        success: function (data) {
            SendFocusCmd = !0
        },
        error: function (data) {
            SendFocusCmd = !0
        }
    }))
}

function farStopAction(refreshHndlr) {
    SendFarStopCmd && (restartTimerManager(refreshHndlr), SendFarStopCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "focusmanualnfar=0",
        success: function (data) {
            SendFarStopCmd = !0
        },
        error: function (data) {
            SendFarStopCmd = !0
        }
    }))
}
var SendCtrlCmd = !0,
    SendCtrlTrackingModeCmd = !0,
    SendPTStopCmd = !0,
    SendZStopCmd = !0,
    zoomSlid = 0,
    icon_zoomSlid = 0,
    zoomSlidBtnMinus = 0,
    zoomSlidBtnPlus = 0,
    zoomScaleFactorInverse, zoomRangeArray;

function ptTrackingActionCtrl(ptzactionflg, trackingmode) {
    return null !== ptzactionflg && (SendCtrlCmd = ptzactionflg), SendCtrlTrackingModeCmd = !("Partition" == trackingmode && !SendCtrlCmd), SendCtrlCmd
}

function ptActionCtrl(ptzactionflg) {
    return null !== ptzactionflg && (SendCtrlCmd = ptzactionflg), SendCtrlCmd
}

function ptStopAction(refreshHndlr1, refreshHndlr2) {
    SendPTStopCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendPTStopCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "ptstop=1",
        success: function (data) {
            logDebug("ptz stop success"), SendPTStopCmd = !0
        },
        error: function (data) {
            SendPTStopCmd = !0
        }
    }))
}

function setZoomAction(textId, value, refreshHndlr1, refreshHndlr2) {
    var cmdVal = "zoompositionfromindex=";
    SendCtrlCmd && (cmdVal = cmdVal.concat(value), restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: cmdVal,
        success: function (data) {
            $(textId).val(zoomRangeArray[value - 1]), zoomSlid.setValue((value - 1) * zoomScaleFactorInverse), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function zoomStopAction(refreshHndlr1, refreshHndlr2) {
    SendZStopCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendZStopCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "zoomstop=1",
        success: function (data) {
            SendZStopCmd = !0
        },
        error: function (data) {
            SendZStopCmd = !0
        }
    }))
}

function zoomoutAction(refreshHndlr1, refreshHndlr2) {
    SendCtrlCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "zoomoutstart=1",
        success: function (data) {
            SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function zoominAction(refreshHndlr1, refreshHndlr2) {
    SendCtrlCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "zoominstart=1",
        success: function (data) {
            SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function upAction(refreshHndlr1, refreshHndlr2) {
    SendCtrlCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "tiltupstart=1",
        success: function (data) {
            logDebug("ptz up success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function downAction(refreshHndlr1, refreshHndlr2) {
    SendCtrlCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "tiltdownstart=1",
        success: function (data) {
            logDebug("ptz down success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function stageleftAction(refreshHndlr1, refreshHndlr2) {
    SendCtrlCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "panleftstart=1",
        success: function (data) {
            logDebug("ptz left success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }), $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "stageroileftaim=0",
        success: function (data) {
            logDebug("ptz left success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function stagerightAction(refreshHndlr1, refreshHndlr2) {
    SendCtrlCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "panrightstart=1",
        success: function (data) {
            logDebug("ptz right success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }), $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "stageroirightaim=0",
        success: function (data) {
            logDebug("ptz right success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function leftAction(refreshHndlr1, refreshHndlr2) {
    !SendCtrlCmd && SendCtrlTrackingModeCmd || (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "panleftstart=1",
        success: function (data) {
            logDebug("ptz left success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function rightAction(refreshHndlr1, refreshHndlr2) {
    !SendCtrlCmd && SendCtrlTrackingModeCmd || (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "panrightstart=1",
        success: function (data) {
            logDebug("ptz right success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function homeAction(refreshHndlr1, refreshHndlr2) {
    SendCtrlCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "ptzgotohome=1",
        success: function (data) {
            logDebug("ptz home success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function upLeftAction(refreshHndlr1, refreshHndlr2) {
    SendCtrlCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "panlefttiltup=1",
        success: function (data) {
            logDebug("ptz up-left success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function upRightAction(refreshHndlr1, refreshHndlr2) {
    SendCtrlCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "panrighttiltup=1",
        success: function (data) {
            logDebug("ptz up-right success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function downLeftAction(refreshHndlr1, refreshHndlr2) {
    SendCtrlCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "panlefttiltdown=1",
        success: function (data) {
            logDebug("ptz down-left success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function downRightAction(refreshHndlr1, refreshHndlr2) {
    SendCtrlCmd && (restartTimerManager(refreshHndlr1, refreshHndlr2), SendCtrlCmd = !1, $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: "panrighttiltdown=1",
        success: function (data) {
            logDebug("ptz down-right success"), SendCtrlCmd = !0
        },
        error: function (data) {
            SendCtrlCmd = !0
        }
    }))
}

function presetTextAction(strSet) {
    var strVal = $("#presetId").val();
    switch (strVal.length) {
        case 0:
            strVal = strVal.concat(strSet);
            break;
        case 1:
            strVal = "0" == strVal ? strSet : strVal.concat(strSet);
            break;
        case 2:
            strSet < "8" ? strVal <= "12" && (strVal = strVal.concat(strSet)) : strVal <= "11" && (strVal = strVal.concat(strSet));
            break;
        case 3:
            break;
        case 4:
            strVal = ""
    }
    $("#presetId").val(strVal)
}

function Num1Action() {
    var strSet = "1";
    presetTextAction("1")
}

function Num2Action() {
    var strSet = "2";
    presetTextAction("2")
}

function Num3Action() {
    var strSet = "3";
    presetTextAction("3")
}

function Num4Action() {
    var strSet = "4";
    presetTextAction("4")
}

function Num5Action() {
    var strSet = "5";
    presetTextAction("5")
}

function Num6Action() {
    var strSet = "6";
    presetTextAction("6")
}

function Num7Action() {
    var strSet = "7";
    presetTextAction("7")
}

function Num8Action() {
    var strSet = "8";
    presetTextAction("8")
}

function Num9Action() {
    var strSet = "9";
    presetTextAction("9")
}

function Num0Action() {
    var strSet = "0";
    presetTextAction("0")
}

function cleanAction() {
    $("#presetId").val("")
}

function saveAction(refreshHndlr1, refreshHndlr2) {
    var cmdVal = "savepreset=",
        strVal = $("#presetId").val();
    0 !== strVal.length && (restartTimerManager(refreshHndlr1, refreshHndlr2), cmdVal = cmdVal.concat(strVal), $("#presetId").val(""), $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: cmdVal,
        success: function (data) {
            logDebug("save preset success")
        }
    }))
}

function loadAction(refreshHndlr1, refreshHndlr2) {
    var cmdVal = "loadpreset=",
        strVal = $("#presetId").val();
    0 !== strVal.length && (restartTimerManager(refreshHndlr1, refreshHndlr2), cmdVal = cmdVal.concat(strVal), $("#presetId").val(""), $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: cmdVal,
        success: function (data) {
            logDebug("load preset success")
        }
    }))
}

function mkElem(tag, attrs, child) {
    var elem = $("<" + tag + " />").attr(attrs),
        childArray = $.makeArray(child);
    return $.each(childArray, (function (i, c) {
        elem.append(c)
    })), elem
}

function mkElemClass(tag, classes, child) {
    return mkElem(tag, {
        class: classes
    }, child)
}

function mkElemClassAndID(tag, classes, id, child) {
    return mkElem(tag, {
        class: classes,
        id: id
    }, child)
}

function mkElemHref(tag, link, child, classes) {
    return mkElem(tag, {
        href: link,
        target: "_blank",
        class: classes
    }, child)
}

function mkElemId(tag, id, child) {
    return mkElem(tag, {
        id: id
    }, child)
}

function joinAttrs(attrs, name, list) {
    return list.length > 0 && (attrs[name] = list.join(" ")), attrs
}

function mkControlGroup(label, controls, help) {
    var controlDiv = mkElemClass("div", "controls", controls);
    help && controlDiv.append(mkElemClass("span", "help-inline").text(help));
    var labelElem = "string" == typeof label ? mkElemClass("label", "control-label", label) : label;
    return mkElemClass("div", "control-group", [labelElem, controlDiv])
}

function mkControlGroupAdvanced(lhs, controls, options) {
    var controlDiv = mkElemClass("div", "controls", controls);
    return options.help && controlDiv.append(mkElemClass("span", "help-inline").text(options.help)), mkElemClass("div", ["control-group", options.class].join(" "), [lhs, controlDiv])
}

function mkIcon(type) {
    return mkElemClass("i", type)
}
var validInputOptions = ["id", "value", "disabled", "type", "class", "maxlength", "max"];

function filterChildren(orig, validChildren) {
    var result = {};
    return $.each(validChildren, (function (i, c) {
        void 0 !== orig[c] && (result[c] = orig[c])
    })), result
}

function liesBetween(low, value, high) {
    return low <= value && value <= high
}
var ASCII = {
    BACKSPACE: 8,
    TAB: 9,
    CR: 13,
    SPACE: 32,
    LEFT: 37,
    UP: 38,
    RIGHT: 39,
    DOWN: 40,
    COMMA: 44,
    HYPHEN: 45,
    PERIOD: 46,
    SLASH: 47,
    ZERO: 48,
    NINE: 57,
    COLON: 58,
    SEMICOLON: 59,
    AT: 64,
    A: 65,
    Z: 90,
    UNDERSCORE: 95,
    a: 97,
    z: 122
};

function isASCIIControlKey(keycode) {
    return keycode === ASCII.BACKSPACE || keycode === ASCII.CR || keycode === ASCII.TAB
}

function isASCIINumKey(keycode) {
    return liesBetween(ASCII.ZERO, keycode, ASCII.NINE)
}

function isASCIIAlphabetKey(keycode) {
    return liesBetween(ASCII.A, keycode, ASCII.Z) || liesBetween(ASCII.a, keycode, ASCII.z)
}

function isASCIISpecialKey(specialKeyCodes, keycode) {
    return exists(specialKeyCodes, (function (i, e) {
        return keycode === e
    }))
}

function isASCIIArrowkey(keycode) {
    return liesBetween(ASCII.LEFT, keycode, ASCII.DOWN)
}

function keyEventCheck(keyEvent, predicates) {
    var keycode = keyEvent.which ? keyEvent.which : keyEvent.keycode,
        keyOk;
    return logDebug("keyCode is...", keycode), (keyOk = void 0 === keycode || exists(predicates, (function (i, predicate) {
        return predicate(keycode)
    }))) || logDebug("Rejecting key", keycode), keyOk
}

function isASCIINegKey(keycode) {
    return keycode === ASCII.HYPHEN
}

function filterNegNumKey(keyEvent) {
    return keyEventCheck(keyEvent, [isASCIIControlKey, isASCIINumKey, isASCIINegKey])
}

function filterNumKey(keyEvent) {
    return keyEventCheck(keyEvent, [isASCIIControlKey, isASCIINumKey])
}

function filterAlphaNumKey(keyEvent) {
    return keyEventCheck(keyEvent, [isASCIIControlKey, isASCIINumKey, isASCIIAlphabetKey])
}

function filterSnapshotFilenameKey(keyEvent) {
    return keyEventCheck(keyEvent, [isASCIIControlKey, isASCIINumKey, isASCIIAlphabetKey, curry(isASCIISpecialKey, [ASCII.UNDERSCORE])])
}

function filterZoneNameKey(keyEvent) {
    return keyEventCheck(keyEvent, [isASCIIControlKey, isASCIINumKey, isASCIIAlphabetKey, curry(isASCIISpecialKey, [ASCII.UNDERSCORE])])
}

function filterIPAddressKey(keyEvent) {
    return keyEventCheck(keyEvent, [isASCIIControlKey, isASCIINumKey, curry(isASCIISpecialKey, [ASCII.PERIOD])])
}

function filterArrowKey(keyEvent) {
    return keyEventCheck(keyEvent, [isASCIIArrowkey])
}

function registerChangeHandlers(jqObj, handler) {
    return jqObj.change(handler).keyup(handler).click(handler).bind("input propertyChange", handler)
}

function registerRadioCheckButtonChangeHandlers(jqObj, handler) {
    return jqObj.change(handler)
}

function updInputElem(options) {
    options.id || alert("Please set element id!");
    var element = "#" + options.id;
    return $(element).val(options.value), !0 === options.disabled ? $(element)[0].disabled = !0 : $(element)[0].disabled = !1, registerChangeHandlers($(element), options.change)
}

function mkInputElem(options) {
    return registerChangeHandlers(mkElem("input", $.extend({
        type: "text"
    }, filterChildren(options, validInputOptions))), options.change)
}

function updInlineInput(options) {
    var inputElem = updInputElem(options).clone();
    return mkElem("label", {}, [document.getElementById(options.id).parentElement.innerText, inputElem])
}

function mkInlineInput(options) {
    var inputElem = mkInputElem(options);
    return mkElem("label", {}, [options.label, inputElem])
}

function mkInput(options) {
    var inputElem = mkInputElem(options),
        controls = options.prependIcon ? mkElemClass("div", "input-prepend").append(mkElemClass("span", "add-on", mkIcon(options.prependIcon)), inputElem) : inputElem;
    return mkControlGroup(options.label, [controls, options.help])
}

function updInputElemTextArea(options) {
    options.id || alert("Please set element id!");
    var element = "#" + options.id;
    return $(element).val(options.value), $(element)[0].disabled = !0 === options.disabled, $(element)
}

function mkInputElemTextArea(options) {
    return registerChangeHandlers(mkElem("textarea", {
        id: options.id,
        class: options.class,
        rows: options.rows,
        value: options.value,
        disabled: options.disabled,
        readonly: options.readonly,
        style: "overflow-x:hidden;resize:none"
    }), options.change)
}

function mkInlineInputTextArea(options) {
    var inputElem = mkInputElemTextArea(options);
    return mkElem("label", {}, [options.label, inputElem])
}

function mkCameraTitle(label, attrs, icon, id) {
    var extAttrs = $.extend({
            type: "text"
        }, attrs),
        controls;
    return mkControlGroup(label, [mkElemClass("div", "input-prepend", [mkElemClass("span", "add-on", mkIcon(icon)), mkElem("input", extAttrs)]), mkElem("label", {
        id: id
    })])
}

function updPrependedInput(options, changeHndlr) {
    options.id || alert("Please set element id!");
    var element = "#" + options.id;
    return $(element).val(options.value), $(element)[0].disabled = !0 === options.disabled, registerChangeHandlers($(element), changeHndlr)
}

function mkPrependedInput(label, attrs, icon, changeHndlr) {
    var extAttrs = $.extend({
            type: "text"
        }, attrs),
        controls;
    return mkControlGroup(label, mkElemClass("div", "input-prepend", [mkElemClass("span", "add-on", mkIcon(icon)), registerChangeHandlers(mkElem("input", extAttrs), changeHndlr)]))
}

function updateSelection(id, choices, selectedIndex) {
    var selectElem = $("#" + id).empty();
    $.each(choices, (function (i, m) {
        mkElem("option", {
            selected: i === selectedIndex
        }, m).appendTo(selectElem)
    }))
}

function mkSelectionElem(id, choices, optionsArg) {
    var attrs, selectElem = mkElem("select", {
            id: id,
            class: optionsArg.selectClass,
            disabled: optionsArg.disabled
        }).change(optionsArg.change),
        selectedIndex = optionsArg.selectedIndex ? parseDecimal(optionsArg.selectedIndex) : null;
    return $.each(choices, (function (i, m) {
        mkElem("option", {
            selected: i === selectedIndex
        }, m).appendTo(selectElem)
    })), selectedIndex >= choices.length && (logDebug("Overflowing choice"), updateSelection(id, choices, 0), selectElem.change()), selectElem
}

function updSelectionInput2(id, choices, options) {
    id || alert("Please set element id!");
    var element = "#" + id,
        selectElem = $(element).change(options.change);
    $(element)[0].disabled = !0 === options.disabled;
    var selectedIndex = options.selectedIndex ? parseDecimal(options.selectedIndex) : null;
    return selectedIndex < choices.length ? updateSelection(id, choices, selectedIndex) : (logDebug("Overflowing choice"), updateSelection(id, choices, 0), selectElem.change()), selectElem.parent().parent()
}

function mkSelectionInput(label, id, choices, options) {
    var selectElem;
    return mkControlGroup(label, mkSelectionElem(id, choices, options), options.help)
}

function updSelectionInput(id, choices, options) {
    id || alert("Please set element id!");
    var element = "#" + id,
        selectElem = $(element).change(options.change);
    $(element)[0].disabled = !0 === options.disabled;
    var selectedIndex = options.selectedIndex ? parseDecimal(options.selectedIndex) : null;
    return selectedIndex < choices.length ? updateSelection(id, choices, selectedIndex) : (logDebug("Overflowing choice"), updateSelection(id, choices, 0), selectElem.change()), selectElem.parent()
}

function mkInlineSelectionInput(label, id, choices, options) {
    var selectElem;
    return mkElem("label", {}, [label, mkSelectionElem(id, choices, options)]).append(mkElemClass("span", "help-inline").text(options.help))
}

function mkLableSelectionInput(label, id, choices, options) {
    var selectElem = mkSelectionElem(id, choices, options);
    return mkElem("label", {}, [label, mkSpaceLarge(), selectElem]).append(mkElemClass("span", "help-inline").text(options.help))
}

function mkListLink(m, header, clickHndlr) {
    var c = [];
    header && c.push("nav-header"), m.active && (navigator.userAgent.match("Firefox") ? c.push("firefox-side-active") : c.push("side-active"));
    var lnk = m.link || "#";
    if (m.prj_title) var liChild = mkElem("a", {
        href: lnk
    }, [m.icon ? mkElemClass("i", m.icon) : null, mkElemClassAndID("span", "project", "CameraNameId", m.project)]);
    else var liChild = mkElem("a", {
        href: lnk
    }, [m.icon ? mkElemClass("i", m.icon) : null, mkElemClass("span", "title", m.title)]);
    var elem = mkElem("li", {
        class: c.join(" "),
        id: m.id
    }, liChild);
    return liChild.click(curry(clickHndlr, elem)), m.hidden ? elem.hide() : elem
}

function mkNavList(topHeader, classStr, menus) {
    var nav = $("<ul />").addClass(classStr);
    return $.each(menus, (function (i, m) {
        null !== m && nav.append(mkListLink(m, topHeader, m.click))
    })), nav
}

function mkNavigator(menus, entryCallback) {
    var data = {
            currSelection: null,
            linkElems: []
        },
        nav = mkElem("ul", {
            id: "sideBarId",
            class: "nav nav-list"
        });

    function defNavHandler(parent, menu, elem) {
        if (navigator.userAgent.match("Firefox"))
        function afterClose() {
            if ($(".firefox-side-active", nav).removeClass("firefox-side-active"), $(".active-as-parent", nav).removeClass("active-as-parent"), data.currSelection = menu, entryCallback && entryCallback(), menu.click) $(elem).addClass("firefox-side-active"), $(parent).addClass("active-as-parent"), menu.click();
            else if (menu.children) {
                $(elem).addClass("active-as-parent");
                var firstChild = menu.children[0];
                $("#" + firstChild.id).addClass("firefox-side-active"), data.currSelection = firstChild, firstChild.click && firstChild.click()
            }
        } else
        function afterClose() {
            if ($(".side-active", nav).removeClass("side-active"), $(".active-as-parent", nav).removeClass("active-as-parent"), data.currSelection = menu, entryCallback && entryCallback(), menu.click) $(elem).addClass("side-active"), $(parent).addClass("active-as-parent"), menu.click();
            else if (menu.children) {
                $(elem).addClass("active-as-parent");
                var firstChild = menu.children[0];
                $("#" + firstChild.id).addClass("side-active"), data.currSelection = firstChild, firstChild.click && firstChild.click()
            }
        }
        data.currSelection && data.currSelection.close ? data.currSelection.close(afterClose) : afterClose()
    }
    return $.each(menus, (function (i, m) {
        if (null !== m) {
            var mLink = mkListLink(m, !0, curry(defNavHandler, null, m));
            data.linkElems.push(mLink), nav.append(mLink), $.each($.makeArray(m.children), (function (i, child) {
                nav.append(mkListLink(child, !1, curry(defNavHandler, mLink, child)))
            }))
        }
    })), {
        elem: mkElemClass("div", "sidebar-nav", nav),
        switchTo: function (n) {
            defNavHandler(null, menus[n], data.linkElems[n])
        }
    }
}

function mkTabbable(id, tabs, topElems, classes) {
    var tabList = mkElemClass("ul", "nav nav-tabs"),
        tabContent = {};
    return tabContent = mkElemClass("div", classes ? "tab-content " + classes : "tab-content"), $.each(tabs, (function (i, tab) {
        var c = [];
        tab.active && c.push("active");
        var liChild = mkElem("a", {
            href: "#" + tab.target,
            "data-toggle": "tab"
        }, tab.label);
        if (liChild.click(tab.click), tabList.append(mkElemClass("li", c, liChild)), tab.content) {
            var tabContentClass = "tab-pane";
            tab.active && (tabContentClass += " active"), tabContent.append(mkElem("div", {
                id: tab.target,
                class: tabContentClass
            }, tab.content))
        }
    })), tabList.append(topElems), mkElem("div", {
        id: id,
        class: "tabbable"
    }, [tabList, tabContent])
}

function internalMakeCheckButton(label, id, classStr, options) {
    var checked = options && options.checked,
        disabled, attr = options && options.disabled ? {
            disabled: "disabled"
        } : {},
        finalClassStr, elem = mkElemClass("label", classStr + (options.class ? options.class : ""), [mkElem("input", $.extend(attr, {
            id: id,
            type: "checkbox",
            checked: checked
        })), label]),
        hndlr;
    options && options.change && registerRadioCheckButtonChangeHandlers(elem, (function () {
        options.change("checked" === $("#" + id).attr("checked"))
    }));
    return elem
}

function updCheckButtonElem(id, options) {
    return internalMakeCheckButton(document.getElementById(id).parentElement.innerText, id, "checkbox ", options)
}

function mkCheckButtonElem(label, id, options) {
    return internalMakeCheckButton(label, id, "checkbox ", options)
}

function mkInlineCheckButtonElem(label, id, options) {
    return internalMakeCheckButton(label, id, "checkbox inline ", options)
}

function updCheckButton(id, options) {
    var control;
    return mkControlGroup("", mkCheckButtonElem(document.getElementById(id).parentElement.innerText, id, options))
}

function mkCheckButton(label, id, options) {
    var control;
    return mkControlGroup("", mkCheckButtonElem(label, id, options))
}

function internalMakeRadioButton(label, id, groupName, classStr, options) {
    var checked = options && options.checked,
        finalClassStr, inputOptions, elem = mkElemClass("label", [classStr, options.class ? options.class : "", options.disabled ? "disabled" : ""].join(" "), [mkElem("input", $.extend({}, {
            id: id,
            value: options.value,
            type: "radio",
            checked: checked,
            name: groupName
        }, options.disabled ? {
            disabled: "disabled"
        } : {})), label]),
        hndlr;
    options && options.change && registerRadioCheckButtonChangeHandlers(elem, (function () {
        options.change("checked" === $("#" + id).attr("checked"))
    }));
    return elem
}

function updRadioButtonElem(id, groupName, options) {
    return internalMakeRadioButton(document.getElementById(id).parentElement.innerText, id, groupName, "radio", options)
}

function mkRadioButtonElem(label, id, groupName, options) {
    return internalMakeRadioButton(label, id, groupName, "radio ", options)
}

function mkInlineRadioButtonElem(label, id, groupName, options) {
    return internalMakeRadioButton(label, id, groupName, "radio inline ", options)
}

function mkRadioButtonControls(id, optionLabels, options) {
    var controls = [];
    return $.each(optionLabels, (function (i, l) {
        var isObj = $.isPlainObject(l),
            label = isObj ? l.label : l,
            disabled = !!isObj && l.disabled,
            radioOptions = $.extend({}, i === options.selectedIndex ? {
                checked: "checked"
            } : {}, {
                disabled: disabled
            }),
            c = mkInlineRadioButtonElem(label, id + i, id, radioOptions);
        options.callback && c.click(curry(options.callback, i)), controls.push(c)
    })), controls
}

function mkRadioButtons(label, id, optionLabels, options) {
    var controls;
    return mkControlGroup(label, mkRadioButtonControls(id, optionLabels, options))
}

function mkFieldSet(legend, inFields) {
    var fields = [mkElem("legend", {}, legend)];
    return $.each(inFields, (function (i, f) {
        fields.push(f)
    })), mkElem("fieldset", {}, fields)
}

function makeButton(label, attrs, clickHndlr) {
    return mkElem("button", attrs, label).click(clickHndlr)
}

function bindButton(id, clickHndlr) {
    return $("#" + id).click(clickHndlr)
}

function mkButton(label, extraClasses, clickHndlr) {
    return mkElemClass("button", ["btn", extraClasses].join(" "), label).click(clickHndlr)
}

function mkImgButton(label, extraClasses, clickHndlr) {
    return mkElemClass("button", ["", extraClasses].join(" "), label).click(clickHndlr)
}

function mkPresetButton(label, extraClasses, clickHndlr, refreshHndlr1, refreshHndlr2) {
    return mkElemClass("button", ["btn", extraClasses].join(" "), label).click((function () {
        clickHndlr(refreshHndlr1, refreshHndlr2)
    }))
}

function imgButtonControls(label, extraClasses, id, clickHndlr) {
    return mkControlGroup(label, [mkElemClassAndID("button", ["", extraClasses].join(" "), id, "").click(clickHndlr)])
}

function imgBTNControls(icon, idname, label, clickHndlr) {
    return mkElemClass("div", "control-group", [mkElemClass("label", "control-label", label), "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", mkElem("button", {
        class: "btn btn-ptz",
        id: idname
    }, mkElemClass("i", icon)).click(clickHndlr)])
}

function imgBTNPrimaryBTNControls(icon, idname, label, clickHndlr, idset, labelset, clickHndlrset) {
    return mkElemClass("div", "control-group", [mkElemClass("label", "control-label", label), "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", mkElem("button", {
        class: "btn btn-ptz",
        id: idname
    }, mkElemClass("i", icon)).click(clickHndlr), "&nbsp;", "&nbsp;", mkElem("button", {
        id: idset,
        type: "button",
        class: "btn btn-primary"
    }, labelset).click(clickHndlrset)])
}

function imgBTNHoldBTNControls(icon, idname, label, clickHndlr, actionHndlr) {
    return mkElemClass("div", "control-group", [mkElemClass("label", "control-label", label), "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", mkHoldDownIconButton(icon, "Left", idname, actionHndlr, ptStopAction, clickHndlr)])
}

function imgBTNHoldBTNPrimaryBTNControls(icon, idname, label, clickHndlr, actionHndlr, idset, labelset, clickHndlrset) {
    return mkElemClass("div", "control-group", [mkElemClass("label", "control-label", label), "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", mkHoldDownIconButton(icon, "Left", idname, actionHndlr, ptStopAction, clickHndlr), "&nbsp;", "&nbsp;", mkElem("button", {
        id: idset,
        type: "button",
        class: "btn btn-primary"
    }, labelset).click(clickHndlrset)])
}

function NormalBTNControls(label, idset, labelset, clickHndlrset) {
    return mkElemClass("div", "control-group", [mkElemClass("label", "control-label", label), "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", mkElem("button", {
        id: idset,
        type: "button",
        class: "btn"
    }, labelset).click(clickHndlrset)])
}

function PrimaryBTNControls(label, idset, labelset, clickHndlrset) {
    return mkElemClass("div", "control-group", [mkElemClass("label", "control-label", label), "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", "&nbsp;", mkElem("button", {
        id: idset,
        type: "button",
        class: "btn btn-primary"
    }, labelset).click(clickHndlrset)])
}

function labelBTN(label, idset, labelset, clickHndlrset, type) {
    return mkElemClass("div", "control-group", [mkElemClass("label", "lumenswb2-label", label), "&nbsp;", "&nbsp;", mkElem("button", {
        id: idset,
        type: "button",
        class: type
    }, labelset).click(clickHndlrset)])
}

function mkIdButton(label, id, clickHndlr, classes) {
    return mkElem("button", {
        class: "btn " + classes,
        id: id
    }, label).click(clickHndlr)
}

function mkIconButton(icon, tooltip, id, clickHndlr, classes) {
    return mkElem("button", {
        class: "btn " + classes,
        id: id
    }, mkElemClass("i", icon)).tooltip({
        title: tooltip,
        placement: "bottom"
    }).click((function () {
        $(this).tooltip("hide"), clickHndlr()
    }))
}

function mkHoldDownIconButton(icon, tooltip, id, clickHndlr, stopHndlr, refreshHndlr1, refreshHndlr2) {
    var ptTimer;
    return mkElem("button", {
        class: "btn btn-ptz",
        id: id
    }, mkElemClass("i", icon)).tooltip({
        title: tooltip,
        placement: "bottom"
    }).click((function () {
        $(this).tooltip("hide"), null !== ptTimer && (clearInterval(ptTimer), ptTimer = null), null !== stopHndlr && stopHndlr(refreshHndlr1, refreshHndlr2)
    })).mousedown((function () {
        $(this).tooltip("hide"), clickHndlr(refreshHndlr1, refreshHndlr2);
        var i = 0;
        null != ptTimer && (clearInterval(ptTimer), ptTimer = null), ptTimer = setInterval((function () {
            (i += 80) >= 1e3 && (i = 0, "buttonHome" != id && ($(this).tooltip("hide"), clickHndlr(refreshHndlr1, refreshHndlr2)))
        }), 10)
    })).mouseup((function () {
        $(this).tooltip("hide"), null != ptTimer && (clearInterval(ptTimer), ptTimer = null), null != stopHndlr && stopHndlr(refreshHndlr1, refreshHndlr2)
    })).mouseleave((function () {
        $(this).tooltip("hide"), null != ptTimer && (clearInterval(ptTimer), ptTimer = null), null != stopHndlr && stopHndlr(refreshHndlr1, refreshHndlr2)
    }))
}

function mkRow(colTag, cols) {
    return mkElem("tr", {}, $.map(cols, (function (c) {
        return $.isPlainObject(c) ? mkElem(colTag, c.options, c.label) : mkElem(colTag, {}, c)
    })))
}

function mkTable(headerTitles, rowData, options) {
    var rowElems = $.map(rowData, (function (r) {
            return mkRow("td", r)
        })),
        tableClass;
    return mkElem("table", {
        class: "table " + (options.tableClass || ""),
        id: options.id
    }, [mkElem("thead", {}, mkRow("th", headerTitles)), mkElem("tbody", {}, rowElems)])
}

function makeToolBar(headerTitles, rowData, options) {
    var rowElems = $.map(rowData, (function (r) {
            return mkRow("td", r)
        })),
        tableClass;
    return mkElem("table", {
        class: "lumenswb2-table " + (options.tableClass || ""),
        id: options.id
    }, [mkElem("thead", {}, mkRow("th", headerTitles)), mkElem("tbody", {}, rowElems)])
}
var isIE = function (ver) {
        var b = document.createElement("b");
        return b.innerHTML = "\x3c!--[if IE " + ver + "]><i></i><![endif]--\x3e", 1 === b.getElementsByTagName("i").length
    },
    pictureScaleFactorInverse, pictureScaleFactorInverseSarpness, audioScaleFactorInverseSarp, audioScaleFactorInverseSarpness, audioDelayScaleFactorSarpness, slidBright, slidInputcontast, slidSaturate, slidSharp, slidVolume, slidDelay;

function makeTable(headerTitles, tableData, options) {
    if (isIE(7) || isIE(8)) {
        for (var rowElems = [], rowElems0 = [], rowElems1 = [], rowElems2 = [], rowElems3 = [], rowElems4 = [], i = 0; i < tableData.length - 1; i++) switch (rowElems = $.map(tableData[i], (function (r) {
            return mkElem("th", {}, r)
        })), i) {
            case 0:
                rowElems0 = mkElem("tr", {}, rowElems);
                break;
            case 1:
                rowElems1 = mkElem("tr", {}, rowElems);
                break;
            case 2:
                rowElems2 = mkElem("tr", {}, rowElems);
                break;
            case 3:
                rowElems3 = mkElem("tr", {}, rowElems);
                break;
            case 4:
                rowElems4 = mkElem("tr", {}, rowElems)
        }
        var tableClass;
        return mkElem("table", {
            class: tableClass = "lumenswb2-help-inline " + (options.tableClass || ""),
            id: options.id
        }, [mkRow("th", headerTitles), rowElems0, rowElems1, rowElems2, rowElems3, rowElems4])
    }
    var tableElems, rowElems, tableClass;
    return tableElems = $.map(tableData, (function (tb) {
        return rowElems = $.map(tb, (function (r) {
            return mkElem("th", {}, r)
        })), mkElem("tr", {}, rowElems)
    })), mkElem("table", {
        class: tableClass = "lumenswb2-table lumenswb2-help-inline " + (options.tableClass || ""),
        id: options.id
    }, [mkRow("th", headerTitles), tableElems])
}

function makeInlineSelectionInput(label, id, choices, options, classes) {
    var selectElem;
    return mkElem("nobr", {
        class: classes
    }, [label, "&nbsp;&nbsp;", mkSelectionElem(id, choices, options)]).append(mkElemClass("span", "help-inline").text(options.help))
}

function makePresetTable(headerTitles, presetData, tableData, options) {
    if (isIE(7) || isIE(8)) {
        for (var presetElems = presetData, rowElems = [], rowElems0 = [], rowElems1 = [], rowElems2 = [], rowElems3 = [], rowElems4 = [], i = 0; i < tableData.length - 1; i++) switch (rowElems = $.map(tableData[i], (function (r) {
            return mkElem("th", {}, r)
        })), i) {
            case 0:
                rowElems0 = mkElem("tr", {}, rowElems);
                break;
            case 1:
                rowElems1 = mkElem("tr", {}, rowElems);
                break;
            case 2:
                rowElems2 = mkElem("tr", {}, rowElems);
                break;
            case 3:
                rowElems3 = mkElem("tr", {}, rowElems);
                break;
            case 4:
                rowElems4 = mkElem("tr", {}, rowElems)
        }
        var tableClass;
        return mkElem("table", {
            class: tableClass = "lumenswb2-help-inline " + (options.tableClass || ""),
            id: options.id
        }, [presetElems, mkRow("th", headerTitles), rowElems0, rowElems1, rowElems2, rowElems3, rowElems4])
    }
    var presetElems = presetData,
        tableElems = [],
        rowElems = [],
        tableClass;
    return tableElems = $.map(tableData, (function (tb) {
        return rowElems = $.map(tb, (function (r) {
            return mkElem("th", {}, r)
        })), mkElem("tr", {}, rowElems)
    })), mkElem("table", {
        class: tableClass = "lumenswb2-help-inline " + (options.tableClass || ""),
        id: options.id
    }, [presetElems, mkRow("th", headerTitles), tableElems])
}

function mkProgressBar(id) {
    return mkElem("div", {
        id: id,
        class: "progress"
    }, mkElemClass("div", "bar").css({
        width: "0%"
    }))
}

function updateProgressBar(selector, completion) {
    $(".bar", selector).css({
        width: 100 * completion + "%"
    })
}

function validateNumericField(fieldSelector, maxLengthIn, callback) {
    var filterAlphaNum = /[^0-9]/g,
        maxLength = maxLengthIn || 1e5;

    function inputChange() {
        var strVal = $(fieldSelector).val(),
            newVal = 0 === strVal.length ? "" : parseDecimal(strVal.slice(0, maxLength));
        strVal !== "" + newVal && $(fieldSelector).val(newVal), callback && callback(newVal)
    }
    registerChangeHandlers($(fieldSelector), inputChange).keypress(filterNumKey)
}

function validateIPAddressNumber(fieldSelector, callback) {
    var filterAlphaNum = /[^0-9.]/g;

    function inputChange() {
        var strVal = $(fieldSelector).val(),
            newVal = strVal.replace(filterAlphaNum, "");
        strVal !== newVal && $(fieldSelector).val(newVal), callback && callback(newVal)
    }
    registerChangeHandlers($(fieldSelector), inputChange).keypress(filterIPAddressKey)
}

function validateAlphaNumericField(fieldSelector, callback) {
    var filterAlphaNum = /[^a-zA-Z0-9]/g;

    function inputChange() {
        var strVal = $(fieldSelector).val(),
            newVal = strVal.replace(filterAlphaNum, "");
        strVal !== newVal && $(fieldSelector).val(newVal), callback && callback(newVal)
    }
    registerChangeHandlers($(fieldSelector), inputChange).keypress(filterAlphaNumKey)
}

function validateSnapshotField(fieldSelector, callback) {
    var filterSnap = /[^a-zA-Z0-9_]/g;

    function inputChange() {
        var strVal = $(fieldSelector).val(),
            newVal = strVal.replace(filterSnap, "");
        logDebug(strVal, "->", newVal), strVal !== newVal && $(fieldSelector).val(newVal), callback && callback(newVal)
    }
    registerChangeHandlers($(fieldSelector), inputChange).keypress(filterSnapshotFilenameKey)
}

function validateZoneNameField(fieldSelector, callback) {
    var filterSnap = /[^a-zA-Z0-9_]/g;

    function inputChange() {
        var strVal = $(fieldSelector).val(),
            newVal = strVal.replace(filterSnap, "");
        logDebug(strVal, "->", newVal), strVal !== newVal && $(fieldSelector).val(newVal), callback && callback(newVal)
    }
    registerChangeHandlers($(fieldSelector), inputChange).keypress(filterZoneNameKey)
}

function filterSizeField(fieldSelector, maxSize, callback, strVal) {
    var newVal = strVal.slice(0, maxSize);
    strVal !== newVal && $(fieldSelector).val(newVal), callback && callback(newVal)
}

function validateDatefield(selector) {
    $(selector).keydown(filterArrowKey)
}

function validateIntegerField(fieldSelector, min, max, callback) {
    function inputChange() {
        var strVal = $(fieldSelector).val(),
            newVal = 0 === strVal.length ? 0 : parseDecimal(strVal);
        min <= 1 && min >= 0 && (newVal = Math.max(newVal, min)), strVal !== "" + (newVal = Math.min(max, newVal)) && $(fieldSelector).val(newVal), callback && callback(newVal)
    }
    registerChangeHandlers($(fieldSelector), inputChange).keypress(filterNumKey)
}

function checkNotEmpty(fieldName, selector) {
    var cnfLvl;
    return 0 === $(selector).val().length ? {
        valid: !1,
        msg: "Please enter a value for " + fieldName + "."
    } : {
        valid: !0
    }
}

function updSlidingControls(sliderId, textId) {
    return mkControlGroup(document.getElementById(sliderId).parentElement.parentElement.innerText, [mkElem("div", {
        class: "dragdealer inline",
        id: sliderId
    }, mkElem("div", {
        class: "red-bar handle"
    })).mousedown((function () {
        logDebug("slidingControls - mousedown")
    })).mouseup((function () {
        logDebug("slidingControls - mouseup")
    })).mouseout((function () {
        logDebug("slidingControls - mouseout")
    })).mouseover((function () {
        logDebug("slidingControls - mouseover")
    })), mkElem("input", {
        class: "input-micro",
        id: textId,
        type: "text"
    })])
}

function slidingControls(label, sliderId, textId) {
    return mkControlGroup(label, [mkElem("div", {
        class: "dragdealer inline",
        id: sliderId
    }, mkElem("div", {
        class: "red-bar handle"
    })).mousedown((function () {
        logDebug("slidingControls - mousedown")
    })).mouseup((function () {
        logDebug("slidingControls - mouseup")
    })).mouseout((function () {
        logDebug("slidingControls - mouseout")
    })).mouseover((function () {
        logDebug("slidingControls - mouseover")
    })), mkElem("input", {
        class: "input-micro",
        id: textId,
        type: "text"
    })])
}

function makekLabel(label, classes) {
    return mkElemClass("label", classes ? "help-inline " + classes : "help-inline", label)
}

function buttonControls(label, btnMinusId, btnPlusId, textId, help) {
    var controls;
    return mkControlGroup(label, [mkSpace(), mkSpace(), mkSpace(), mkSpace(), mkElem("button", {
        class: "btn btn-minus-plus",
        id: btnMinusId
    }, mkElemClass("i", "icon-minus")), mkElem("button", {
        class: "btn btn-minus-plus lumenswb2-btn-plus-relative-left",
        id: btnPlusId
    }, mkElemClass("i", "icon-plus")), mkElem("input", {
        class: "input-micro",
        id: textId,
        type: "text"
    })])
}

function slidingInlineControls(label, sliderId, textId, help) {
    var slider = mkElem("nobr", {
            class: "dragdealer inline",
            id: sliderId
        }, mkElem("div", {
            class: "red-bar handle"
        })),
        textVal = mkElem("input", {
            class: "input-micro",
            id: textId,
            type: "text"
        });
    return mkElem("nobr", {}, [label, slider, textVal]).append(mkElemClass("span", "help-inline").text(help))
}

function slidingBtnInlineControls(btnMinusId, label, sliderId, textId, btnPlusId, help) {
    var minusBtn = mkElem("button", {
            class: "btn btn-ptz",
            id: btnMinusId
        }, mkElemClass("i", "icon-zoom-out")),
        slider = mkElem("div", {
            class: "dragdealer inline",
            id: sliderId
        }, mkElem("div", {
            class: "red-bar handle",
            id: "icon_" + sliderId
        })),
        textVal = mkElem("input", {
            class: "input-micro lumenswb2-zoom-relative-left",
            id: textId,
            type: "text",
            disabled: "disabled"
        }),
        plusBtn = mkElem("button", {
            class: "btn btn-ptz",
            id: btnPlusId
        }, mkElemClass("i", "icon-zoom-in"));
    return mkElem("div", {}, [minusBtn, label, slider, plusBtn, textVal]).append(mkElemClass("span", "help-inline").text(help))
}

function buttonInlineControls(label, btnMinusId, btnPlusId, textId, help) {
    var minusBtn = mkElem("button", {
            class: "btn btn-minus-plus",
            id: btnMinusId
        }, mkElemClass("i", "icon-minus")),
        plusBtn = mkElem("button", {
            class: "btn btn-minus-plus lumenswb2-btn-plus-relative-left",
            id: btnPlusId
        }, mkElemClass("i", "icon-plus")),
        inputTxt = mkElem("input", {
            class: "input-micro",
            id: textId,
            type: "text"
        });
    return mkElem("nobr", {}, [label, minusBtn, plusBtn, inputTxt]).append(mkElemClass("span", "help-inline").text(help))
}

function zoomRangeDisable() {
    null !== zoomSlid && (zoomSlid.disable = !0), null !== zoomSlidBtnMinus && (zoomSlidBtnMinus.disable = !0), null !== zoomSlidBtnPlus && (zoomSlidBtnPlus.disable = !0)
}

function zoomRangeEnable() {
    null !== zoomSlid && (zoomSlid.disable = !1), null !== zoomSlidBtnMinus && (zoomSlidBtnMinus.disable = !1), null !== zoomSlidBtnPlus && (zoomSlidBtnPlus.disable = !1)
}

function zoomRangeControl(btnMinusId, sliderId, textId, btnPlusId, settings, para, minVal, maxVal, dimens, refreshHndlr1, refreshHndlr2) {
    var strVal, idxVal, newVal, zoomPos, zoomTimer1, zoomTimer2, regExp = /^(-?[0-9]*|0)$/g,
        txtId = textId.replace("#", ""),
        cmdVal, version = settings.softwareversion;

    function getIndex(val) {
        for (var i = 0; i < maxVal; i++)
            if (zoomRangeArray[i] == val) return i
    }
    zoomRangeArray = -1 != version.search("VHB") || -1 != version.search("VHR") || -1 != version.search("VAY") || -1 != version.search("VIL") || -1 != version.search("VKZ") || -1 != version.search("VLY") ? [1, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2, 2.2, 2.4, 2.6, 2.8, 3, 3.3, 3.6, 4, 4.5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20] : [1, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2, 2.2, 2.4, 2.6, 2.8, 3, 3.3, 3.6, 3.9, 4, 4.5, 5, 6, 7, 8, 9, 10], $(textId).val(zoomRangeArray[settings[para] - 1]);
    var scaleFactor = maxVal - minVal;
    zoomScaleFactorInverse = 1 / scaleFactor, zoomSlid = new Dragdealer(sliderId, {
        x: (settings[para] - 1) * zoomScaleFactorInverse,
        animationCallback: function (x, y) {
            var value = Math.round(x * scaleFactor)
        },
        callback: function (x) {
            var value = Math.round(x * scaleFactor);
            setZoomAction(textId, value + 1, refreshHndlr1, refreshHndlr2)
        }
    }), zoomSlidBtnMinus = $(btnMinusId), zoomSlidBtnPlus = $(btnPlusId), maxVal < minVal || ($(btnMinusId).click((function () {
        null != zoomTimer1 && (clearInterval(zoomTimer1), zoomTimer1 = null), parseDecimal(strVal = getIndex($(textId).val())) != minVal - 1 && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) - dimens, newVal = Math.min(maxVal - 1, Math.max(newVal, minVal - 1)), setZoomAction(textId, newVal + 1, refreshHndlr1, refreshHndlr2))
    })), $(btnMinusId).mousedown((function () {
        var i = 0;
        null != zoomTimer1 && (clearInterval(zoomTimer1), zoomTimer1 = null), zoomTimer1 = setInterval((function () {
            (i += 80) >= 1500 && (i = 0, parseDecimal(strVal = getIndex($(textId).val())) != minVal - 1 && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) - dimens, newVal = Math.min(maxVal - 1, Math.max(newVal, minVal - 1)), setZoomAction(textId, newVal + 1, refreshHndlr1, refreshHndlr2)))
        }), 10)
    })), $(btnMinusId).mouseup((function () {
        null != zoomTimer1 && (clearInterval(zoomTimer1), zoomTimer1 = null), restartTimerManager(refreshHndlr1, refreshHndlr2)
    })), $(btnMinusId).mouseleave((function () {
        null != zoomTimer1 && (clearInterval(zoomTimer1), zoomTimer1 = null), restartTimerManager(refreshHndlr1, refreshHndlr2)
    })), $(btnPlusId).click((function () {
        null != zoomTimer2 && (clearInterval(zoomTimer2), zoomTimer2 = null), parseDecimal(strVal = getIndex($(textId).val())) != maxVal - 1 && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) + dimens, newVal = Math.min(maxVal - 1, Math.max(newVal, minVal - 1)), setZoomAction(textId, newVal + 1, refreshHndlr1, refreshHndlr2))
    })), $(btnPlusId).mousedown((function () {
        var i = 0;
        null != zoomTimer2 && (clearInterval(zoomTimer2), zoomTimer2 = null), zoomTimer2 = setInterval((function () {
            (i += 80) >= 1500 && (i = 0, parseDecimal(strVal = getIndex($(textId).val())) != maxVal - 1 && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) + dimens, newVal = Math.min(maxVal - 1, Math.max(newVal, minVal - 1)), setZoomAction(textId, newVal + 1, refreshHndlr1, refreshHndlr2)))
        }), 10)
    })), $(btnPlusId).mouseup((function () {
        null != zoomTimer2 && (clearInterval(zoomTimer2), zoomTimer2 = null), restartTimerManager(refreshHndlr1, refreshHndlr2)
    })), $(btnPlusId).mouseleave((function () {
        null != zoomTimer2 && (clearInterval(zoomTimer2), zoomTimer2 = null), restartTimerManager(refreshHndlr1, refreshHndlr2)
    })))
}

function zoomSliderUpdateVal(textId, value) {
    $(textId).val(zoomRangeArray[value - 1]), zoomSlid.setValue((value - 1) * zoomScaleFactorInverse)
}

function manualFocusControl(btnMinusId, btnPlusId, textId, settings, para, minVal, maxVal, dimens, refreshHndlr) {
    var strVal, newVal, timer1, timer2, regExp = /^(-?[0-9]*|0)$/g,
        txtId = textId.replace("#", "");

    function inputChange() {
        strVal = $(textId).val(), (newVal = strVal.match(regExp)) ? (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal), newVal = Math.min(maxVal, Math.max(newVal, minVal))) : newVal = 0, setFocusAction(textId, newVal, refreshHndlr)
    }
    maxVal < minVal || ($(textId).val(settings[para]), $(btnMinusId).click((function () {
        !1 === document.getElementById(txtId).disabled && (null != timer1 && (clearInterval(timer1), timer1 = null), parseDecimal(strVal = $(textId).val()) != minVal && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) - dimens, newVal = Math.min(maxVal, Math.max(newVal, minVal)), setFocusAction(textId, newVal, refreshHndlr)))
    })), $(btnMinusId).mousedown((function () {
        var i = 0;
        null != timer1 && (clearInterval(timer1), timer1 = null), timer1 = setInterval((function () {
            (i += 80) >= 1e3 && (i = 0, !1 === document.getElementById(txtId).disabled && parseDecimal(strVal = $(textId).val()) != minVal && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) - dimens, newVal = Math.min(maxVal, Math.max(newVal, minVal)), setFocusAction(textId, newVal, refreshHndlr)))
        }), 10)
    })), $(btnMinusId).mouseup((function () {
        null != timer1 && (clearInterval(timer1), timer1 = null), restartTimerManager(refreshHndlr)
    })), $(btnMinusId).mouseleave((function () {
        null != timer1 && (clearInterval(timer1), timer1 = null), restartTimerManager(refreshHndlr)
    })), $(btnPlusId).click((function () {
        !1 === document.getElementById(txtId).disabled && (null != timer2 && (clearInterval(timer2), timer2 = null), parseDecimal(strVal = $(textId).val()) != maxVal && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) + dimens, newVal = Math.min(maxVal, Math.max(newVal, minVal)), setFocusAction(textId, newVal, refreshHndlr)))
    })), $(btnPlusId).mousedown((function () {
        var i = 0;
        null != timer2 && (clearInterval(timer2), timer2 = null), timer2 = setInterval((function () {
            (i += 80) >= 1e3 && (i = 0, !1 === document.getElementById(txtId).disabled && parseDecimal(strVal = $(textId).val()) != maxVal && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) + dimens, newVal = Math.min(maxVal, Math.max(newVal, minVal)), setFocusAction(textId, newVal, refreshHndlr)))
        }), 10)
    })), $(btnPlusId).mouseup((function () {
        null != timer2 && (clearInterval(timer2), timer2 = null), restartTimerManager(refreshHndlr)
    })), $(btnPlusId).mouseleave((function () {
        null != timer2 && (clearInterval(timer2), timer2 = null), restartTimerManager(refreshHndlr)
    })), registerChangeHandlers($(textId), inputChange).keypress(filterNumKey))
}

function connectButtonToInput(btnMinusId, btnPlusId, textId, settings, para, minVal, maxVal, dimens, instant, refreshHndlr) {
    var strVal, newVal, timer1, timer2, regExp0 = /^-+$/g,
        regExp = /^(-?[0-9]*|0)$/g,
        txtId = textId.replace("#", "");
    if (!(maxVal < minVal))
        if ($(textId).val(settings[para]), $(btnMinusId).click((function () {
                !1 === document.getElementById(txtId).disabled && (null != timer1 && (clearInterval(timer1), timer1 = null), parseDecimal(strVal = $(textId).val()) != minVal && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) - dimens, newVal = Math.min(maxVal, Math.max(newVal, minVal)), 1 == instant ? setCmdAction(textId, para, newVal, refreshHndlr) : ($(textId).val(newVal), settings[para] = newVal)))
            })), $(btnMinusId).mousedown((function () {
                var i = 0;
                null != timer1 && (clearInterval(timer1), timer1 = null), timer1 = setInterval((function () {
                    (i += 80) >= 1500 && (i = 0, !1 === document.getElementById(txtId).disabled && parseDecimal(strVal = $(textId).val()) != minVal && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) - dimens, newVal = Math.min(maxVal, Math.max(newVal, minVal)), 1 == instant ? setCmdAction(textId, para, newVal, refreshHndlr) : ($(textId).val(newVal), settings[para] = newVal, null != refreshHndlr && restartTimerManager(refreshHndlr))))
                }), 10)
            })), $(btnMinusId).mouseup((function () {
                null != timer1 && (clearInterval(timer1), timer1 = null)
            })), $(btnMinusId).mouseleave((function () {
                null != timer1 && (clearInterval(timer1), timer1 = null)
            })), $(btnPlusId).click((function () {
                !1 === document.getElementById(txtId).disabled && (null != timer2 && (clearInterval(timer2), timer2 = null), parseDecimal(strVal = $(textId).val()) != maxVal && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) + dimens, newVal = Math.min(maxVal, Math.max(newVal, minVal)), 1 == instant ? (setCmdAction(textId, para, newVal, refreshHndlr), refreshHndlr()) : ($(textId).val(newVal), settings[para] = newVal, null != refreshHndlr && restartTimerManager(refreshHndlr))))
            })), $(btnPlusId).mousedown((function () {
                var i = 0;
                null != timer2 && (clearInterval(timer2), timer2 = null), timer2 = setInterval((function () {
                    (i += 80) >= 1500 && (i = 0, !1 === document.getElementById(txtId).disabled && parseDecimal(strVal = $(textId).val()) != maxVal && (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal) + dimens, newVal = Math.min(maxVal, Math.max(newVal, minVal)), 1 == instant ? setCmdAction(textId, para, newVal, refreshHndlr) : ($(textId).val(newVal), settings[para] = newVal, null != refreshHndlr && restartTimerManager(refreshHndlr))))
                }), 10)
            })), $(btnPlusId).mouseup((function () {
                null != timer2 && (clearInterval(timer2), timer2 = null)
            })), $(btnPlusId).mouseleave((function () {
                null != timer2 && (clearInterval(timer2), timer2 = null)
            })), "#epCompLvlId" == textId) {
            function inputChange() {
                (strVal = $(textId).val()).match(regExp) ? (newVal = "-", $(textId).val(newVal)) : ((newVal = strVal.match(regExp)) ? (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal), newVal = Math.min(maxVal, Math.max(newVal, minVal))) : newVal = "-" == strVal.charAt(strVal.length - 1) ? strVal.substring(0, strVal.length - 1) : 0, 1 == instant ? setCmdAction(textId, para, newVal, refreshHndlr) : ($(textId).val(newVal), settings[para] = newVal))
            }
            registerChangeHandlers($(textId), inputChange).keypress(filterNegNumKey)
        } else {
            function inputChange() {
                strVal = $(textId).val(), (newVal = strVal.match(regExp)) ? (newVal = 0 === strVal.length ? 0 : parseDecimal(strVal), newVal = Math.min(maxVal, Math.max(newVal, minVal))) : newVal = 0, 1 == instant ? setCmdAction(textId, para, newVal, refreshHndlr) : ($(textId).val(newVal), settings[para] = newVal)
            }
            registerChangeHandlers($(textId), inputChange).keypress(filterNumKey)
        }
}

function configAction(para_str, val, refreshHndlr) {
    restartTimerManager(refreshHndlr), $.ajax({
        url: IPNC.serverURL + "vb.htm",
        data: para_str + "=" + val,
        success: function (data) {
            logDebug("vb response")
        }
    })
}

function connectSliderToInput(sliderId, outId, settings, para, scaleFactor, refreshHndlr) {
    var updateValue = !1,
        brightValue = -1,
        contastValue = -1,
        saturateValue = -1,
        sharpValue = -1,
        volumeValue = -1,
        delayValue = -1,
        newBrightVal = -1,
        newContastValue = -1,
        newSaturateValue = -1,
        newSharpValue = -1,
        newVolumeValue = -1,
        newDelayValue = -1,
        paraName = "",
        scaleFactorInverse = 1 / scaleFactor,
        data = {
            editing: !1
        },
        slid = new Dragdealer(sliderId, {
            x: settings[para] * scaleFactorInverse,
            animationCallback: function (x, y) {
                var value = Math.round(x * scaleFactor);
                switch (outId) {
                    case "#brightId":
                        brightValue = value, paraName = "brightness";
                        break;
                    case "#inputcontastId":
                        contastValue = value, paraName = "contrast";
                        break;
                    case "#saturateId":
                        saturateValue = value, paraName = "saturation";
                        break;
                    case "#sharpId":
                        sharpValue = value, paraName = "sharpness";
                        break;
                    case "#volumeId":
                        volumeValue = value, paraName = "volumenessId";
                        break;
                    case "#delayId":
                        0 === value && (value = 1), delayValue = value, paraName = "delaynessId"
                }
                data.editing || ($(outId).val(value), updateValue = !0)
            },
            callback: function (x) {
                var value = Math.round(x * scaleFactor);
                switch (data.editing = !1, outId) {
                    case "#volumeId":
                    case "#delayId":
                        settings[para] = value
                }
                updateValue && (configAction(paraName, value, refreshHndlr), updateValue = !1)
            }
        });

    function inputChange() {
        var strVal = $(outId).val(),
            newVal = 0 === strVal.length ? 0 : parseDecimal(strVal);
        switch (newVal = Math.min(scaleFactor, Math.max(newVal, 0)), data.editing = !0, strVal !== "" + newVal && $(outId).val(newVal), outId) {
            case "#brightId":
                brightValue !== newVal && newBrightVal !== newVal && (newBrightVal = newVal, configAction("brightness", newVal, refreshHndlr));
                break;
            case "#inputcontastId":
                contastValue !== newVal && newContastValue !== newVal && (newContastValue = newVal, configAction("contrast", newVal, refreshHndlr));
                break;
            case "#saturateId":
                saturateValue !== newVal && newSaturateValue !== newVal && (newSaturateValue = newVal, configAction("saturation", newVal, refreshHndlr));
                break;
            case "#sharpId":
                sharpValue !== newVal && newSharpValue !== newVal && (newSharpValue = newVal, configAction("sharpness", newVal, refreshHndlr));
                break;
            case "#volumeId":
                volumeValue !== newVal && newVolumeValue !== newVal && (newVolumeValue = newVal, configAction("volumenessId", newVal, refreshHndlr));
                break;
            case "#delayId":
                delayValue !== newVal && newDelayValue !== newVal && (newDelayValue = newVal, configAction("delaynessId", newVal, refreshHndlr))
        }
        switch (slid.setValue(newVal * scaleFactorInverse), outId) {
            case "#volumeId":
            case "#delayId":
                settings[para] = newVal
        }
    }
    if ("#brightId" == outId || "#inputcontastId" == outId || "#saturateId" == outId || "#sharpId" == outId || "#volumeId" == outId || "#delayId" == outId) switch (outId) {
        case "#brightId":
            slidBright = slid, pictureScaleFactorInverse = scaleFactorInverse;
            break;
        case "#inputcontastId":
            slidInputcontast = slid, pictureScaleFactorInverse = scaleFactorInverse;
            break;
        case "#saturateId":
            slidSaturate = slid, pictureScaleFactorInverse = scaleFactorInverse;
            break;
        case "#sharpId":
            slidSharp = slid, pictureScaleFactorInverseSarpness = scaleFactorInverse;
            break;
        case "#volumeId":
            slidVolume = slid, audioScaleFactorInverseSarpness = scaleFactorInverse;
            break;
        case "#delayId":
            slidDelay = slid, audioDelayScaleFactorSarpness = scaleFactorInverse
    }
    registerChangeHandlers($(outId), inputChange).keypress(filterNumKey)
}

function pictureSliderUpdateView(disable) {
    !1 !== disable && !0 !== disable || (disable ? (slidBright.disable(), slidInputcontast.disable(), slidSaturate.disable()) : (slidBright.enable(), slidInputcontast.enable(), slidSaturate.enable()))
}

function audioSliderUpdateView(disable) {
    !1 !== disable && !0 !== disable || (disable ? (slidVolume.enable(), slidVolume.editing = !0) : (slidVolume.disable(), slidVolume.editing = !1))
}

function audioDelaySliderUpdateView(disable) {
    !1 !== disable && !0 !== disable || (disable ? (slidDelay.enable(), slidDelay.editing = !0) : (slidDelay.disable(), slidDelay.editing = !1))
}

function pictureSliderUpdateVal(textId, value) {
    switch (textId) {
        case "#brightId":
            slidBright.setValue(value * pictureScaleFactorInverse), document.getElementById("brightId").value = value;
            break;
        case "#inputcontastId":
            slidInputcontast.setValue(value * pictureScaleFactorInverse), document.getElementById("inputcontastId").value = value;
            break;
        case "#saturateId":
            slidSaturate.setValue(value * pictureScaleFactorInverse), document.getElementById("saturateId").value = value;
            break;
        case "#sharpId":
            slidSharp.setValue(value * pictureScaleFactorInverseSarpness), document.getElementById("sharpId").value = value
    }
}

function audioSliderUpdateVal(textId, value) {
    switch (textId) {
        case "#volumeId":
            slidVolume.setValue(value * audioScaleFactorInverseSarpness);
            break;
        case "#delayId":
            slidDelay.setValue(value * audioDelayScaleFactorSarpness)
    }
}

function centerWrap(elem) {
    return mkElemClass("div", "center-wrap", elem)
}

function mkBreak() {
    return mkElem("br", {})
}

function mkSpace() {
    return "&nbsp;"
}

function mkSpaceLarge() {
    return "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
}

function newLine() {
    return mkElem("br", {})
}

function space() {
    return mkElem("span", {}, "&nbsp;")
}

function createTab(tabId, tabLabel, tabTarget, tabContent, topElems, classes) {
    return mkTabbable(tabId, [{
        label: tabLabel,
        target: tabTarget,
        content: tabContent
    }], topElems, classes)
}

function enableInput(selector, enabled) {
    enabled ? $(selector).removeAttr("disabled").parent("label").removeClass("disabled") : $(selector).attr("disabled", "disabled").parent("label").addClass("disabled")
}

function checkMarkInput(selector, checked) {
    checked ? $(selector).attr("checked", "checked") : $(selector).removeAttr("checked")
}

function range() {
    var L = arguments,
        start, stop, step, r = [],
        i = 0;
    for (1 === L.length ? (start = 0, stop = L[0], step = 1) : (start = L[0], stop = L[1], step = $.isNumeric(L[2]) ? L[2] : 1), i = start; step > 0 ? i < stop : i > stop; i += step) r.push(i);
    return r
}

function curry(f) {
    var args = $.makeArray(arguments).slice(1);
    return args.length < 1 && logError("curry called with zero arguments for currying"),
        function () {
            if (f) return f.apply(this, args.concat($.makeArray(arguments)))
        }
}

function parseDecimal(x) {
    return parseInt(x, 10)
}

function pad2(x) {
    return x < 10 ? "0" + x : "" + x
}

function padPrefix(str, prefix, n) {
    var padChars = n - str.length;
    return padChars > 0 ? map(range(padChars), (function (i, e) {
        return prefix
    })).join("") + str : str
}

function map(a, callback) {
    var res = [];
    return $.each(a, (function (i, v) {
        res.push(callback(i, v))
    })), res
}

function forAll(a, verifier) {
    var valid = !0;
    return $.each(a, (function (i, e) {
        var res = verifier(i, e);
        valid = valid && res
    })), valid
}

function exists(a, verifier) {
    var valid = !1;
    return $.each(a, (function (i, e) {
        verifier(i, e) && (valid = !0)
    })), valid
}

function reduce(arr, callback) {
    if (!(arr.length < 2)) return 2 === arr.length ? callback(arr[0], arr[1]) : callback(arr[0], reduce(arr.slice(1), callback))
}

function group(arr, size) {
    for (var result = [], countNew = arr.length / size, i = 0; i < countNew; i++) result.push(arr.slice(i * size, (i + 1) * size));
    return result
}

function validateUserNamePassword(server, fieldName, selector) {
    var namepswd = $(selector).val(),
        max = "Password" === fieldName ? 16 : 32,
        msg = mkElem("p", {}, server + "  " + fieldName + " is mandatory field"),
        msgmax = mkElem("p", {}, fieldName + " should have minimum of 4 characters and maximum of " + max + " characters");
    return 0 === namepswd.length ? {
        valid: !1,
        msg: msg
    } : namepswd.length < 4 || namepswd.length > max ? {
        valid: !1,
        msg: msgmax
    } : {
        valid: !0
    }
}

function ipValidation(fieldName, selector) {
    var ip = $(selector).val(),
        flag = !1,
        iplen = (ip = "" + ip).length,
        errorMsg = mkElem("p", {}, "Invalid " + fieldName);
    if (0 === iplen) return {
        valid: !1,
        msg: mkElem("p", {}, fieldName + " is mandatory field")
    };
    var ipArr = ip.split(".");
    return 4 !== ipArr.length ? {
        valid: !1,
        msg: errorMsg
    } : ($.each(range(4), (function (i) {
        if (ipArr[i] = 0 === ipArr[i].length ? 0 : parseDecimal(ipArr[i]), ipArr[i] > 255) return flag = !0, !1
    })), flag ? {
        valid: !1,
        msg: errorMsg
    } : (ipArr = ipArr.join("."), $(selector).val(ipArr), {
        valid: !0
    }))
}

function validateSmtpIPAddress(fieldName, selector) {
    var ip = $(selector).val(),
        iplen = (ip = "" + ip).length,
        dotCnt = 0,
        msg = mkElem("p", {}, fieldName + " should be in correct format");
    if (0 === iplen) return {
        valid: !1,
        msg: mkElem("p", {}, fieldName + " is mandatory field")
    };
    var fstChar = ip.slice(0, 1);
    if ("." === fstChar || "@" === fstChar || "-" === fstChar) return {
        valid: !1,
        msg: msg
    };
    if ("." === ip.slice(-1)) return {
        valid: !1,
        msg: msg
    };
    for (var loopCnt = 0; loopCnt < iplen; loopCnt++) {
        var Char = ip[loopCnt],
            charInt = ip[loopCnt].charCodeAt(0);
        if (!(charInt >= 64 && charInt <= 90 || charInt >= 97 && charInt <= 122 || 45 === charInt || 46 === charInt || charInt >= 48 && charInt <= 58)) return {
            valid: !1,
            msg: msg
        };
        if ("." === Char && (dotCnt++, "." === ip[loopCnt + 1])) return {
            valid: !1,
            msg: msg
        }
    }
    return dotCnt < 1 || dotCnt > 3 ? {
        valid: !1,
        msg: mkElem("p", {}, "Invalid " + fieldName)
    } : {
        valid: !0
    }
}

function validateNumeric() {
    var num = $(this).val(),
        reg = /[0-9\.]/;
    return logDebug("Entered", num.slice(0)), -1 !== num.search(reg)
}

function validateIPAddress(fieldName, selector) {
    var ip = $(selector).val(),
        ipParts = (ip = "" + ip).split(/\./),
        reg = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;

    function xLabel() {
        return mkElemClass("span", "label", "xxx")
    }
    var msg = [mkElem("h4", {}, "Invalid " + fieldName), mkElem("p", {}, ["You entered : ", mkElemClass("span", "label", ip)]), mkElem("p", {}, "IP Address should be in following form:"), mkElem("p", {}, [xLabel(), ".", xLabel(), ".", xLabel(), ".", xLabel(), " where ", xLabel(), " = 1 to 255"])],
        emptymsg = [mkElem("p", {}, fieldName + " is mandatory field")];
    if (0 === ip.length) return {
        valid: !1,
        msg: emptymsg
    };
    if (-1 == ip.search(reg) || 4 != ipParts.length) return {
        valid: !1,
        msg: msg
    };
    if (ipParts[0] < 1 || ipParts[3] < 1) return {
        valid: !1,
        msg: msg
    };
    for (var i = 0; i < 4; i++)
        if (ipParts[i] < 0 || ipParts[i] > 255) return {
            valid: !1,
            msg: msg
        };
    return {
        valid: !0,
        msg: msg
    }
}

function validateEmailAddress(fieldName, selector) {
    var mail = $(selector).val(),
        maillen = (mail = "" + mail).length,
        dotCnt = 0,
        atCnt = 0;
    if (0 === maillen) return {
        valid: !1,
        msg: mkElem("p", {}, fieldName + " is mandatory field")
    };
    var fstChar = mail.slice(0, 1);
    if ("." === fstChar || "@" === fstChar || "-" === fstChar) return {
        valid: !1,
        msg: mkElem("p", {}, fstChar + " is not allowed as first character")
    };
    if ("." === mail.slice(-1)) return {
        valid: !1,
        msg: mkElem("p", {}, ". is not allowed as last character")
    };
    for (var loopCnt = 0; loopCnt < maillen; loopCnt++) {
        var Char = mail[loopCnt],
            charInt = mail[loopCnt].charCodeAt(0);
        if (!(charInt >= 64 && charInt <= 90 || charInt >= 97 && charInt <= 122 || 45 === charInt || 46 === charInt || charInt >= 48 && charInt <= 58)) return {
            valid: !1,
            msg: mkElem("p", {}, "Please enter valid emailId")
        };
        if ("@" === Char && atCnt++, "." === Char && (dotCnt++, "." === mail[loopCnt + 1])) return {
            valid: !1,
            msg: mkElem("p", {}, "Please enter valid emailId")
        }
    }
    return 1 === atCnt && dotCnt >= 1 && dotCnt <= 3 ? {
        valid: !0
    } : {
        valid: !1,
        msg: mkElem("p", {}, "Please enter valid emailId")
    }
}

function validateMinMax(selector, min, max, field) {
    var fieldValue = parseDecimal($(selector).val());
    return isNaN(fieldValue) || min > fieldValue || fieldValue > max ? {
        valid: !1,
        msg: "Minimum " + field + " should be between " + min + " to " + max
    } : {
        valid: !0
    }
}

function validateMinMaxLimit(selector1, min, max, field, fieldName, selector2) {
    var wdthHght1 = parseInt($(selector1).val(), 10),
        wdthHght2 = parseInt($(selector2).val(), 10);
    return isNaN(wdthHght1) || wdthHght1 < min ? {
        valid: !1,
        msg: fieldName + " minimum " + field + " should be greater than or equal to " + min
    } : wdthHght2 > max ? {
        valid: !1,
        msg: fieldName + " maximum " + field + " should be less than or equal to " + max
    } : isNaN(wdthHght2) || wdthHght1 >= wdthHght2 ? {
        valid: !1,
        msg: fieldName + " maximum " + field + " should be greater than  minimun " + field
    } : {
        valid: !0
    }
}

function chainValidatorCopy(descrArray) {
    var i = 0,
        result = {
            valid: !0
        };
    for (i = descrArray.length - 1; i >= 0 && result.valid; i--) {
        var descr = descrArray[i];
        (result = descr.validator(descr.selector, descr.min, descr.max, descr.field, descr.fieldName, descr.selector1)).valid || $(descr.selector).focus()
    }
    return result
}

function chainValidator(descrArray) {
    var i = 0,
        result = {
            valid: !0
        };
    for (i = descrArray.length - 1; i >= 0 && result.valid; i--) {
        var descr = descrArray[i];
        (result = descr.validator(descr.fieldName, descr.selector)).valid || $(descr.selector).focus()
    }
    return result
}

function isDifferent(obj1, obj2) {
    if ($.isPlainObject(obj1) && $.isPlainObject(obj2)) {
        var foundDiff = !1;
        return $.each(obj1, (function (i, v) {
            isDifferent(v, obj2[i]) && (logInfo("object property", i, "was different"), foundDiff = !0)
        })), foundDiff || $.each(obj2, (function (i, v) {
            isDifferent(v, obj1[i]) && (logInfo("object property", i, "was different"), foundDiff = !0)
        })), foundDiff
    }
    if ($.isArray(obj1) && $.isArray(obj2)) {
        var foundArrayDiff = obj1.length !== obj2.length;
        return foundArrayDiff || $.each(obj2, (function (i, v) {
            isDifferent(v, obj1[i]) && (foundArrayDiff = !0)
        })), foundArrayDiff && logDebug("Arrays Different: ", obj1, obj2), foundArrayDiff
    }
    return typeof obj1 == typeof obj2 ? (obj1 !== obj2 && logDebug("Different: ", obj1, obj2), obj1 !== obj2) : (logDebug("Invalid operands for comparison: ", obj1, obj2), !0)
}

function isBitSet(value, bitNum) {
    return 0 != (value & 1 << bitNum)
}

function setBit(bitNum, one) {
    return one ? 1 << bitNum : 0
}

function changeBitOf(num, bitNum, shouldSet) {
    var mask = setBit(bitNum, !0);
    if (shouldSet) return num | mask;
    var bit = num & mask;
    return 0 !== bit ? num ^ bit : num
}

function mkBitMap(arr, bitMapper) {
    var bmp = 0;
    return $.each(arr, (function (i, a) {
        bmp |= bitMapper(i, a)
    })), bmp
}

function capFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1)
}

function mkString(obj) {
    var output = "",
        property;
    for (property in obj) output += property + ": " + obj[property] + ";\n";
    return output
}

function adjustSidebarHeight() {
    $("#sideBarId").css({
        height: $("#mainbar").height() - 10
    })
}

function cnvs_getCoordinates(e) {
    x = e.pageX - e.target.offsetLeft, y = e.pageY - e.target.offsetTop, null !== document.getElementById("xycoordinates") && (document.getElementById("xycoordinates").innerHTML = "Coordinates: (" + x + "," + y + ")")
}

function cnvs_clearCoordinates() {
    null !== document.getElementById("xycoordinates") && (document.getElementById("xycoordinates").innerHTML = "")
}

function dragStart(event) {
    event.dataTransfer.setData("Text", event.target.id)
}

function allowDrop(event) {
    event.preventDefault()
}

function drop(event) {
    event.preventDefault();
    var data = event.dataTransfer.getData("Text");
    event.target.appendChild(document.getElementById(data))
}

Array.prototype.filter || (Array.prototype.filter = function (fun) {
    "use strict";
    if (null == this) throw new TypeError;
    var t = Object(this),
        len = t.length >>> 0;
    if ("function" != typeof fun) throw new TypeError;
    for (var res = [], thisp = arguments[1], i = 0; i < len; i++)
        if (i in t) {
            var val = t[i];
            fun.call(thisp, val, i, t) && res.push(val)
        } return res
});
